#include <bits/stdc++.h>
using namespace std;

struct Poncho {
    long long w, v;
    int idx;
};

int main() {
    int n;
    long long W;
    double eps;
    cin >> n >> W >> eps;

    vector<Poncho> items(n);
    long long max_v = 0;
    for (int i = 0; i < n; i++) {
        cin >> items[i].w >> items[i].v;
        items[i].idx = i + 1;
        max_v = max(max_v, items[i].v);
    }

    double K = eps * max_v / n;
    vector<long long> scaled_v(n);
    for (int i = 0; i < n; i++)
        scaled_v[i] = (long long)(items[i].v / K);

    long long sum_v = accumulate(scaled_v.begin(), scaled_v.end(), 0LL);
    const long long INF = 1e18;
    vector<long long> dp(sum_v + 1, INF);
    vector<int> prv(sum_v + 1, -1);
    dp[0] = 0;

    for (int i = 0; i < n; i++) {
        for (long long v = sum_v; v >= scaled_v[i]; v--) {
            if (dp[v - scaled_v[i]] + items[i].w < dp[v]) {
                dp[v] = dp[v - scaled_v[i]] + items[i].w;
                prv[v] = i;
            }
        }
    }

    long long best_v = 0;
    for (long long v = 0; v <= sum_v; v++)
        if (dp[v] <= W) best_v = v;

    vector<int> taken;
    long long v = best_v;
    while (v > 0) {
        int i = prv[v];
        taken.push_back(items[i].idx);
        v -= scaled_v[i];
    }

    cout << taken.size() << "\n";
    for (int i = (int)taken.size() - 1; i >= 0; i--)
        cout << taken[i] << " ";
    cout << "\n";

    return 0;
}